/*
 * Decompiled with CFR 0.152.
 */
package filenet.vw.toolkit.runtime.summary;

import filenet.vw.toolkit.runtime.VWTrkDataModel;
import filenet.vw.toolkit.runtime.VWTrkMap;
import filenet.vw.toolkit.runtime.summary.VWSummaryInfoTable;
import filenet.vw.toolkit.runtime.summary.VWSummaryInfoTableModel;
import filenet.vw.toolkit.runtime.summary.VWTrackerSummaryInfo;
import filenet.vw.toolkit.utils.table.VWTableSorter;
import java.awt.Frame;
import java.util.Vector;
import javax.swing.JScrollPane;
import javax.swing.JTabbedPane;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import javax.swing.table.TableColumn;

public class VWSummaryInfoPanel
extends JScrollPane
implements ChangeListener {
    private VWSummaryInfoTableModel m_tableModel = null;
    private VWTableSorter m_tableSorter = null;
    private VWSummaryInfoTable m_table = null;
    private boolean m_bStep = false;
    private VWTrkDataModel m_trackerDataModel = null;
    private int m_mapId = -1;
    protected Frame m_parentFrame = null;
    private VWTrackerSummaryInfo m_summaryPanel = null;

    VWSummaryInfoPanel(Frame parentFrame, VWTrackerSummaryInfo summaryPanel, VWTrkDataModel trackerDataModel, int mapId, boolean bStep) {
        this.m_parentFrame = parentFrame;
        this.m_summaryPanel = summaryPanel;
        this.m_bStep = bStep;
        this.m_trackerDataModel = trackerDataModel;
        this.m_mapId = mapId;
    }

    VWSummaryInfoPanel(Frame parentFrame, VWTrkDataModel trackerDataModel, int mapId, boolean bStep) {
        this(parentFrame, null, trackerDataModel, mapId, bStep);
    }

    public void initialize() {
        if (this.m_trackerDataModel == null || this.m_trackerDataModel.getInitState() != 6) {
            return;
        }
        if (this.m_bStep) {
            this.m_tableModel = new VWSummaryInfoTableModel(this.m_trackerDataModel, this.m_mapId, 1);
            this.m_tableSorter = this.m_tableModel.getTableSorter();
            this.m_table = new VWSummaryInfoTable(this.m_parentFrame, this.m_summaryPanel, this.m_tableSorter){

                protected void initColumns() {
                    TableColumn mapColumn = this.m_columnModel.getColumn(0);
                    TableColumn participantColumn = this.m_columnModel.getColumn(3);
                    TableColumn responseColumn = this.m_columnModel.getColumn(6);
                    TableColumn commentsColumn = this.m_columnModel.getColumn(7);
                    if (this.m_tableModel != null && !this.m_tableModel.isAllMaps()) {
                        this.m_columnModel.removeColumn(mapColumn);
                    }
                    this.m_columnModel.removeColumn(participantColumn);
                    this.m_columnModel.removeColumn(responseColumn);
                    this.m_columnModel.removeColumn(commentsColumn);
                }
            };
        } else {
            this.m_tableModel = new VWSummaryInfoTableModel(this.m_trackerDataModel, this.m_mapId, 2);
            this.m_table = new VWSummaryInfoTable(this.m_parentFrame, this.m_summaryPanel, this.m_tableModel){

                protected void initColumns() {
                    TableColumn mapColumn = this.m_columnModel.getColumn(0);
                    this.m_columnModel.removeColumn(mapColumn);
                }
            };
        }
        this.add(this.m_table);
        this.setViewportView(this.m_table);
    }

    public void selectAllSteps() {
        if (this.m_tableModel != null) {
            this.m_tableModel.selectAllSteps();
        }
    }

    public void selectSteps(Vector steps) {
        if (this.m_tableModel != null) {
            this.m_tableModel.setSelected(steps);
        }
    }

    public boolean isMapPanel() {
        return this.m_bStep;
    }

    public int getMapId() {
        return this.m_mapId;
    }

    public VWTrkMap getMap() {
        if (this.isMapPanel() && this.m_trackerDataModel != null) {
            return this.m_trackerDataModel.getMap(this.m_mapId);
        }
        return null;
    }

    public String getMapName() {
        VWTrkMap map = this.getMap();
        if (map != null) {
            return map.getMapName();
        }
        return null;
    }

    public void stateChanged(ChangeEvent e) {
        if (e.getSource() instanceof JTabbedPane && this.m_table != null) {
            JTabbedPane tabbedPane = (JTabbedPane)e.getSource();
            if (tabbedPane.getSelectedComponent() == this) {
                this.m_table.tabSelected(true);
                this.m_table.updateStatusDetailsDialog();
                this.m_table.updateInformationStackDialog();
            } else {
                this.m_table.tabSelected(false);
            }
        }
    }

    public void removeReferences() {
        this.m_parentFrame = null;
        this.m_summaryPanel = null;
        this.m_trackerDataModel = null;
        this.m_tableSorter = null;
        if (this.m_table != null) {
            this.m_table.removeReferences();
            this.m_table = null;
        }
        if (this.m_tableModel != null) {
            this.m_tableModel.removeReferences();
            this.m_tableModel = null;
        }
        this.getViewport().removeAll();
        this.removeAll();
    }
}

